#pragma once

#include "config.h"
#include "logger.h"

#include <drive/library/cpp/aws/init.h>

#include <aws/sqs/SQSClient.h>

#include <util/generic/vector.h>

namespace Aws {
    namespace SQS {
        namespace Model {
            class SendMessageRequest;
            class ReceiveMessageRequest;
            class DeleteMessageRequest;
        }
    }
}

class TSQSClient {
public:
    TSQSClient(const TSQSClientConfig& config);

    const TSQSClientConfig& GetConfig() const {
        return Config;
    }

    bool SendMessage(const TString& queue, const TString& body, TMessagesCollector& errors) const;
    bool RecieveMessages(const TString& queue, TVector<TString>& messages, TVector<Aws::String>& receiptHandles, TMessagesCollector& errors) const;
    bool RecieveMessages(const TString& queue, TVector<TString>& messages, TMessagesCollector& errors, bool removeOriginal = true) const;
    bool DeleteMessages(const TString& queue, const TVector<Aws::String>& receiptHandles, TMessagesCollector& errors) const;

private:
    TAtomicSharedPtr<Aws::SQS::SQSClient> CreateSQSClientInstance(const TSQSClientConfig& config) const;

    Aws::SQS::Model::SendMessageRequest CreateSendMessageRequest(const TString& queue, const TString& body) const;
    Aws::SQS::Model::ReceiveMessageRequest CreateReceiveMessagesRequest(const TString& queue) const;
    Aws::SQS::Model::DeleteMessageRequest CreateDeleteMessageRequest(const TString& queue, const Aws::String& receiptHandle) const;

protected:
    TSQSClientConfig Config;
    TSQSLogger Logger;

    TAwsGuard AwsGuard;
    TAtomicSharedPtr<Aws::SQS::SQSClient> SQSClient;
};
