#include "config.h"

#include <util/string/builder.h>

void TSQSClientConfig::Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy) {
    TBase::Init(section, requestPolicy);
    Account = section->GetDirectives().Value<TString>("Account", Account);
    MaxNumberOfMessages = section->GetDirectives().Value<size_t>("MaxNumberOfMessages", MaxNumberOfMessages);
}

void TSQSClientConfig::ToString(IOutputStream& os) const {
    TBase::ToString(os);
    os << "Account: " << GetAccount() << Endl;
    os << "MaxNumberOfMessages: " << GetMaxNumberOfMessages() << Endl;
}

void TSQSClientConfig::Authorize(NNeh::THttpRequest& /* request */) const {
    // authorization is provided by a client directly
}

TString TSQSClientConfig::CreateQueueUrl(const TString& queue) const {
    return TStringBuilder()
           << ((GetIsHttps()) ? "https://" : "http://")
           << GetHost() << ":" << GetPort() << "/"
           << queue;
}
