#pragma once

#include <rtline/library/deprecated/async_impl/config.h>

class TSQSClientConfig : public TTokenAuthRequestConfig {
    using TBase = TTokenAuthRequestConfig;

    R_FIELD(TString, Account);
    R_FIELD(size_t, MaxNumberOfMessages, 0);

public:
    static TSQSClientConfig ParseFromString(const TString& configStr) {
        return TBase::ParseFromString<TSQSClientConfig>(configStr);
    }

    void Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy = nullptr);
    void ToString(IOutputStream& os) const;
    void Authorize(NNeh::THttpRequest& /* request */) const;

    TString CreateQueueUrl(const TString& queue) const;
};
