#include <drive/library/cpp/sqs/client.h>
#include <drive/library/cpp/sqs/config.h>
#include <library/cpp/testing/unittest/tests_data.h>
#include <library/cpp/testing/unittest/registar.h>

#include <util/string/builder.h>
#include <util/system/env.h>
#include <util/generic/vector.h>

namespace {
    TSQSClientConfig GetSQSClientConfig() {
        auto config = TSQSClientConfig::ParseFromString(
            TStringBuilder()
            << "Host: sqs.yandex.net" << Endl
            << "Port: 8771" << Endl
            << "IsHttps: false" << Endl
            << "Account: cipt-phone-rec-dev" << Endl
            << "Token: " << GetEnv("TESTING_SQS_TOKEN") << Endl
            << "TokenPath: " << GetEnv("TESTING_SQS_TOKEN_PATH") << Endl
            << "RequestTimeout: 1s" << Endl
            << "MaxNumberOfMessages: 10" << Endl  // between 1 and 10
            << "<RequestConfig>" << Endl
            << "    MaxAttempts: 1" << Endl
            << "</RequestConfig>" << Endl
        );
        return config;
    }

    TSQSClient GetSQSClient() {
        return TSQSClient(GetSQSClientConfig());
    }
}

Y_UNIT_TEST_SUITE(SQSClient) {
    Y_UNIT_TEST(ReceiveMessages) {
        auto client = GetSQSClient();

        TVector<TString> messages;
        TMessagesCollector errors;

        UNIT_ASSERT_C(client.RecieveMessages("cipt-phone-rec-dev/cipt-mtt-drive-queue-dev", messages, errors, /* removeOriginal = */ false), errors.GetStringReport());
    }
}
