#include "client.h"

bool TStaffClient::GetMultiPageData(EStaffOperationType operationType, const TStaffEntry::TStaffEntryFields& fields, const NNeh::THttpRequest& request, TStaffEntries& results, TMessagesCollector& errors) const {
    NNeh::THttpRequest modifiedRequest = request;

    do {
        NJson::TJsonValue reply;
        if (!SendRequest(operationType, modifiedRequest, reply, errors)) {
            return false;
        }

        for (const auto& item : reply["result"].GetArray()) {
            TStaffEntry entry(fields);
            if (!entry.DeserializeFromJson(item)) {
                return false;
            }
            results.push_back(std::move(entry));
        }

        modifiedRequest.SetCgiData("");
        if (reply.Has("links")) {
            auto links = reply["links"].GetMap();
            auto nextUrlPtr = links.FindPtr("next");
            if (nextUrlPtr && nextUrlPtr->IsString()) {
                TString nextUrl = nextUrlPtr->GetString();

                auto cgiDataStart = nextUrl.find('?');
                if (cgiDataStart == TString::npos) {
                    return false;
                }

                modifiedRequest.SetCgiData(nextUrl.substr(cgiDataStart));
            }
        }
    } while (modifiedRequest.GetCgiData());

    return true;
}

bool TStaffClient::GetUserData(const TStaffEntrySelector& selector,
                               TStaffEntries& results,
                               TMessagesCollector& errors,
                               const TStaffEntry::TStaffEntryFields& fields,
                               const TString& sortField,
                               size_t limit
) const {
    TString uri = TStringBuilder()
                  << selector.ToCgiParameterString()
                  << "&_fields=" << TStaffEntry(fields).GetFieldsStr()
                  << ((sortField) ? "&_sort=" + sortField : "")
                  << "&_limit=" << limit;
    NNeh::THttpRequest request = CreateCommonRequest(uri);
    return GetMultiPageData(EStaffOperationType::GetUserData, fields, request, results, errors);
}
