#pragma once

#include "config.h"
#include "entry.h"
#include "logger.h"

#include <rtline/library/deprecated/async_impl/client.h>

class TStaffClient : public TRequestClient<TStaffClientConfig, TStaffLogger> {
    using TBase = TRequestClient<TStaffClientConfig, TStaffLogger>;
    using TStaffEntries = TVector<TStaffEntry>;

public:
    TStaffClient(const TStaffClientConfig& config)
        : TBase(config, "staff-api")
    {
    }

    bool GetUserData(const TStaffEntrySelector& selector,
                     TStaffEntries& results,
                     TMessagesCollector& errors,
                     const TStaffEntry::TStaffEntryFields& fields = {},
                     const TString& sortField = "uid",
                     size_t limit = 250
    ) const;

private:
    bool GetMultiPageData(EStaffOperationType operationType, const TStaffEntry::TStaffEntryFields& fields, const NNeh::THttpRequest& request, TStaffEntries& results, TMessagesCollector& errors) const;
};
