#pragma once

#include "config.h"

#include <drive/backend/support_center/support_ai/entities.h>

#include <drive/library/cpp/auth/tvm.h>


namespace NDrive {

    class TSupportAIClient {
    public:
        TSupportAIClient(const TSupportAIApiConfig& config, TAtomicSharedPtr<NTvmAuth::TTvmClient> tvmClient);
        const TSupportAIApiConfig& GetConfig() const;
        NThreading::TFuture<TSupportAICall> MakeCall(const TString& phone, const TMap<TString, TString>& features) const;
        NThreading::TFuture<NJson::TJsonValue> GetCallResult(const TString& callId) const;
        NThreading::TFuture<TString> LoadTrack(const TString& callId) const;

    private:
        TSupportAIApiConfig Config;
        TAtomicSharedPtr<NNeh::THttpClient> Client;
        TMaybe<NDrive::TTvmAuth> TvmAuth;
    };

}
