#include "config.h"

#include <library/cpp/mediator/global_notifications/system_status.h>

#include <util/folder/path.h>
#include <util/stream/file.h>

namespace NDrive {

    bool TSupportAIApiConfig::Init(const TYandexConfig::Section* section) {
        Uri = section->GetDirectives().Value("Uri", Uri);
        CallPath = section->GetDirectives().Value("CallPath", CallPath);
        CallResultPath = section->GetDirectives().Value("CallResultPath", CallResultPath);
        CallRecordPath = section->GetDirectives().Value("CallRecordPath", CallRecordPath);
        ProjectSlug = section->GetDirectives().Value("ProjectId", ProjectSlug);
        SelfClientId = section->GetDirectives().Value("SelfClientId", SelfClientId);
        DestinationTvmId = section->GetDirectives().Value("DestinationTvmId", DestinationTvmId);
        {
            const TYandexConfig::TSectionsMap children = section->GetAllChildren();
            auto it = children.find("RequestConfig");
            if (it != children.end()) {
                RequestConfig.InitFromSection(it->second);
            }
        }
        RequestTimeout  = section->GetDirectives().Value("RequestTimeout", RequestTimeout);
        return true;
    }

    void TSupportAIApiConfig::ToString(IOutputStream& os) const {
        os << "Uri: " << Uri << Endl;
        os << "CallPath: " << CallPath << Endl;
        os << "CallResultPath: " << CallResultPath << Endl;
        os << "CallRecordPath: " << CallRecordPath << Endl;
        os << "ProjectSlug: " << ProjectSlug << Endl;
        os << "SelfClientId: " << SelfClientId << Endl;
        os << "DestinationTvmId: " << DestinationTvmId << Endl;
        os << "<RequestConfig>" << Endl;
        RequestConfig.ToString(os);
        os << "</RequestConfig>" << Endl;
        os << "RequestTimeout : " << RequestTimeout << Endl;
    }

    TAtomicSharedPtr<TSupportAIApiConfig> TSupportAIApiConfig::ParseFromString(const TString& configStr) {
        TAnyYandexConfig config;
        if (!config.ParseMemory(configStr.data())) {
            ERROR_LOG << "Fail to parse config:" + configStr << Endl;
            return nullptr;
        }
        auto result = MakeAtomicShared<TSupportAIApiConfig>();
        if (!result->Init(config.GetRootSection())) {
            return nullptr;
        }
        return result;
    }

}
