#pragma once

#include <rtline/util/network/neh.h>
#include <rtline/util/types/accessor.h>

#include <kernel/daemon/config/daemon_config.h>

namespace NDrive {

    class TSupportAIApiConfig {
    public:
        bool Init(const TYandexConfig::Section* section);
        void ToString(IOutputStream& os) const;
        static TAtomicSharedPtr<TSupportAIApiConfig> ParseFromString(const TString& configStr);

    private:
        R_READONLY(TString, Uri, "http://supportai-calls.taxi.tst.yandex.net/");
        R_READONLY(TString, CallPath, "supportai-calls/v1/calls");
        R_READONLY(TString, CallResultPath, "supportai-calls/v1/calls/results");
        R_READONLY(TString, CallRecordPath, "supportai-calls/v1/calls/__call_id__/record");
        R_READONLY(TString, ProjectSlug, "ya_drive_outgoing_call");
        R_READONLY(ui32, SelfClientId, 0);
        R_READONLY(ui32, DestinationTvmId, 0);
        R_READONLY(NSimpleMeta::TConfig, RequestConfig);
        R_READONLY(TDuration, RequestTimeout, TDuration::Minutes(1));
    };

}
