#include <drive/library/cpp/support_ai/client.h>
#include <drive/library/cpp/threading/future.h>

#include <library/cpp/testing/unittest/tests_data.h>
#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/json/json_reader.h>

#include <util/generic/vector.h>
#include <util/string/builder.h>
#include <util/system/env.h>


Y_UNIT_TEST_SUITE(DriveSupportAISuite) {
    NDrive::TSupportAIApiConfig GetFinesConfig() {
        TStringBuilder config;
        if (auto token = GetEnv("ProjectId")) {
            config << "ProjectId: " << token << Endl;
        }
        auto result = NDrive::TSupportAIApiConfig::ParseFromString(config);
        UNIT_ASSERT(!!result);
        return *result;
    }

    Y_UNIT_TEST(SimpleRequest) {
        const TString phone = GetEnv("TestSupportAIPhone");
        UNIT_ASSERT(phone);
        DoInitGlobalLog("console", FromString<ui32>(GetEnv("LogLevel", "6")), false, false);
        auto config = GetFinesConfig();
        const NDrive::TSupportAIClient client(config, nullptr);
        {
            auto future = client.MakeCall(phone, {{ "scenario_type", "violators" }});
            UNIT_ASSERT(future.Wait(config.GetRequestTimeout()));
            UNIT_ASSERT_C(future.HasValue(), NThreading::GetExceptionMessage(future));
        }
        if (const TString callId = GetEnv("TestSupportAICallId")) {
            auto future = client.GetCallResult(phone);
            UNIT_ASSERT(future.Wait(config.GetRequestTimeout()));
            UNIT_ASSERT_C(future.HasValue(), NThreading::GetExceptionMessage(future));
        }
    }

    Y_UNIT_TEST(GetCallStatus) {
        const TString callId = GetEnv("TestSupportAICallId");
        UNIT_ASSERT(callId);
        DoInitGlobalLog("console", FromString<ui32>(GetEnv("LogLevel", "6")), false, false);
        auto config = GetFinesConfig();
        const NDrive::TSupportAIClient client(config, nullptr);
        auto future = client.GetCallResult(callId);
        UNIT_ASSERT(future.Wait(config.GetRequestTimeout()));
        UNIT_ASSERT_C(future.HasValue(), NThreading::GetExceptionMessage(future));
    }
}
