#pragma once

#include "config.h"

#include <library/cpp/tvmauth/client/facade.h>


class ITakeoutClient {
public:
    virtual bool SendFileToTakeout(const TString& jobId, const TString& filename, const TString& data) const = 0;

    virtual bool FinalizeReport(const TString& jobId, const TVector<TString>& filenames) const = 0;

    virtual ~ITakeoutClient() = default;
};

class TTakeoutClient : public ITakeoutClient {
    using TStringPair = std::pair<TString, TString>;

public:
    TTakeoutClient(const TTakeoutClientConfig& config)
        : Config(config)
    {
        Tvm.Reset(new NTvmAuth::TTvmClient(config.GetTvmSettings(), NTvmAuth::TDevNullLogger::IAmBrave()));
    }

    virtual bool SendFileToTakeout(const TString& jobId, const TString& filename, const TString& data) const override;

    virtual bool FinalizeReport(const TString& jobId, const TVector<TString>& filenames) const override;

private:
    TTakeoutClientConfig Config;
    THolder<NTvmAuth::TTvmClient> Tvm;

    bool SendHttpRequest(const TString& rawPayload) const;
};

class TFakeTakeoutClient : public ITakeoutClient {
    using TStringPair = std::pair<TString, TString>;

public:
    virtual bool SendFileToTakeout(const TString& jobId, const TString& filename, const TString& data) const override;

    virtual bool FinalizeReport(const TString& jobId, const TVector<TString>& filenames) const override;

    TVector<TStringPair> GetArchiveContents(const TString& jobId) const;

private:
    mutable TMap<TString, TVector<TStringPair>> UploadedFiles;
};
