#include "config.h"

#include <util/stream/file.h>
#include <library/cpp/mediator/global_notifications/system_status.h>


void TTakeoutClientConfig::Init(const TYandexConfig::Section* section) {
    Host = section->GetDirectives().Value<TString>("Host", Host);
    Port = section->GetDirectives().Value<ui32>("Port", Port);
    SelfTvmId = section->GetDirectives().Value<ui32>("SelfTvmId", SelfTvmId);
    DestinationTvmId = section->GetDirectives().Value<ui32>("DestinationTvmId", DestinationTvmId);

    TvmKey = section->GetDirectives().Value<TString>("TvmKey", TvmKey);
    if (!TvmKey) {
        TString tokenPath;
        tokenPath = section->GetDirectives().Value<TString>("TvmKeyPath", tokenPath);
        TvmKey = Strip(TFileInput(tokenPath).ReadAll());
    }

    Consumer = section->GetDirectives().Value<TString>("Consumer", Consumer);

    RequestTimeout = section->GetDirectives().Value<TDuration>("RequestTimeout", RequestTimeout);

    DebugOutput = section->GetDirectives().Value<bool>("DebugOutput", DebugOutput);
}

void TTakeoutClientConfig::ToString(IOutputStream& os) const {
    os << "Host: " << Host << Endl;
    os << "Port: " << Port << Endl;
    os << "SelfTvmId: " << SelfTvmId << Endl;
    os << "DestinationTvmId: " << DestinationTvmId << Endl;
    os << "Consumer: " << Consumer << Endl;
    os << "RequestTimeout: " << RequestTimeout << Endl;
    os << "DebugOutput: " << DebugOutput << Endl;
}

TTakeoutClientConfig TTakeoutClientConfig::ParseFromString(const TString& configStr) {
    TTakeoutClientConfig result;
    TAnyYandexConfig config;
    CHECK_WITH_LOG(config.ParseMemory(configStr.data()));
    result.Init(config.GetRootSection());
    return result;
}

NTvmAuth::NTvmApi::TClientSettings TTakeoutClientConfig::GetTvmSettings() const {
    NTvmAuth::NTvmApi::TClientSettings tvmSettings;
    tvmSettings.SetSelfTvmId(SelfTvmId);
    tvmSettings.EnableServiceTicketsFetchOptions(TvmKey, NTvmAuth::NTvmApi::TClientSettings::TDstVector{ DestinationTvmId });
    return tvmSettings;
}
