#pragma once

#include <rtline/util/types/accessor.h>

#include <kernel/daemon/config/daemon_config.h>

#include <library/cpp/logger/global/global.h>
#include <library/cpp/tvmauth/client/facade.h>


class TTakeoutClientConfig {
    R_READONLY(TString, Host);
    R_READONLY(ui32, Port, 0);
    R_READONLY(ui32, SelfTvmId, 0);
    R_READONLY(ui32, DestinationTvmId, 0);
    R_READONLY(TString, TvmKey);

    R_READONLY(TString, Consumer, "yandex_drive_takeout");

    R_READONLY(TDuration, RequestTimeout, TDuration::Seconds(1));

    R_READONLY(bool, DebugOutput, false);

public:
    void Init(const TYandexConfig::Section* section);

    void ToString(IOutputStream& os) const;

    static TTakeoutClientConfig ParseFromString(const TString& configStr);

    NTvmAuth::NTvmApi::TClientSettings GetTvmSettings() const;
};
