#pragma once

#include "config.h"

#include <rtline/util/network/neh.h>
#include <rtline/util/types/expected.h>

#include <library/cpp/tvmauth/client/facade.h>

class TTaxiAntifraudClient {
public:
    class TFacesSimilarityInfo {
        R_FIELD(bool, FoundFaceOnFirstPhoto, false);
        R_FIELD(bool, FoundFaceOnSecondPhoto, false);
        R_FIELD(double, Similarity, 0);
    };

    struct TRecognizedText {
        TString Type;
        TString Text;
        double Confidence = 0;
    };

    class TRecognizedDocument {
        R_FIELD(TVector<TRecognizedText>, RecognizedTexts);
        R_OPTIONAL(double, QuasiGibddScore);
        R_OPTIONAL(double, QuasiFmsScore);
        R_OPTIONAL(double, FromScreenScore);
        R_OPTIONAL(double, BadFormatScore);
    };

public:
    TTaxiAntifraudClient(const TTaxiAntifraudConfig& config, TAtomicSharedPtr<NTvmAuth::TTvmClient> tvmClient)
        : Config(config)
        , TvmClient(tvmClient)
    {
        Agent = MakeHolder<NNeh::THttpClient>(Config.GetUri(), Config.GetRequestConfig());
    }

    NThreading::TFuture<TFacesSimilarityInfo> CalculateFacesSimilarity(const TString& userId, const TString& photo1Blob, const TString& photo2Blob) const;
    NThreading::TFuture<TRecognizedDocument> RecognizePassport(const TString& photoBlob) const;
    NThreading::TFuture<TRecognizedDocument> RecognizeLicenseFront(const TString& photoBlob) const;
    NThreading::TFuture<TRecognizedDocument> RecognizeLicenseBack(const TString& photoBlob) const;

private:
    NThreading::TFuture<TRecognizedDocument> SendPhoto(const TString& photoBlob, const TString& uri) const;

private:
    THolder<NNeh::THttpClient> Agent;
    const TTaxiAntifraudConfig& Config;
    TAtomicSharedPtr<NTvmAuth::TTvmClient> TvmClient;
};
