#include "config.h"

#include <library/cpp/mediator/global_notifications/system_status.h>
#include <util/stream/file.h>

void TTaxiAntifraudConfig::Init(const TYandexConfig::Section* section) {
    Uri = section->GetDirectives().Value<TString>("Uri", Uri);
    FacesSimilarityPath = section->GetDirectives().Value<TString>("FacesSimilarityPath", FacesSimilarityPath);
    RecognizePassportPath = section->GetDirectives().Value<TString>("RecognizePassportPath", RecognizePassportPath);
    RecognizeLicenseFrontPath = section->GetDirectives().Value<TString>("RecognizeLicenseFrontPath", RecognizeLicenseFrontPath);
    RecognizeLicenseBackPath = section->GetDirectives().Value<TString>("RecognizeLicenseBackPath", RecognizeLicenseBackPath);
    SelfTvmId = section->GetDirectives().Value<ui32>("SelfTvmId", SelfTvmId);
    DestinationTvmId = section->GetDirectives().Value<ui32>("DestinationTvmId", DestinationTvmId);
    RequestTimeout = section->GetDirectives().Value<TDuration>("RequestTimeout", RequestTimeout);
    AssertCorrectConfig(!!Uri, "Uri field not defined");
    AssertCorrectConfig(SelfTvmId, "SelfTvmId field not defined");
    AssertCorrectConfig(DestinationTvmId, "DestinationTvmId field not defined");
    const TYandexConfig::TSectionsMap children = section->GetAllChildren();
    auto it = children.find("RequestConfig");
    if (it != children.end()) {
        RequestConfig.InitFromSection(it->second);
    }
}

void TTaxiAntifraudConfig::ToString(IOutputStream& os) const {
    os << "Uri: " << Uri << Endl;
    os << "FacesSimilarityPath: " << FacesSimilarityPath << Endl;
    os << "RecognizePassportPath: " << RecognizePassportPath << Endl;
    os << "RecognizeLicenseFrontPath: " << RecognizeLicenseFrontPath << Endl;
    os << "RecognizeLicenseBackPath: " << RecognizeLicenseBackPath << Endl;
    os << "SelfTvmId: " << SelfTvmId << Endl;
    os << "DestinationTvmId: " << DestinationTvmId << Endl;
    os << "RequestTimeout: " << RequestTimeout << Endl;
    os << "<RequestConfig>" << Endl;
    RequestConfig.ToString(os);
    os << "</RequestConfig>" << Endl;
}

TTaxiAntifraudConfig TTaxiAntifraudConfig::ParseFromString(const TString& configStr) {
    TTaxiAntifraudConfig result;
    TAnyYandexConfig config;
    CHECK_WITH_LOG(config.ParseMemory(configStr.data()));
    result.Init(config.GetRootSection());
    return result;
}
