#pragma once

#include <rtline/library/metasearch/simple/config.h>
#include <rtline/util/types/accessor.h>

#include <library/cpp/yconf/conf.h>

class TTaxiAntifraudConfig {
    R_FIELD(TString, Uri, "http://antifraud-py.taxi.tst.yandex.net");
    R_FIELD(TString, FacesSimilarityPath, "/v1/calculate_faces_similarity");
    R_FIELD(TString, RecognizePassportPath, "/v1/check_passport_title");
    R_FIELD(TString, RecognizeLicenseFrontPath, "/v1/check_driver_license_front");
    R_FIELD(TString, RecognizeLicenseBackPath, "/v1/check_driver_license_back");
    R_FIELD(ui32, SelfTvmId, 0);
    R_FIELD(ui32, DestinationTvmId, 0);
    R_FIELD(TDuration, RequestTimeout, TDuration::Seconds(60));
    R_FIELD(NSimpleMeta::TConfig, RequestConfig);

public:
    static TTaxiAntifraudConfig ParseFromString(const TString& configStr);
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;
};
