#include "config.h"

void TTaxiChatClientConfig::Init(const TYandexConfig::Section* section) {
    Uri = section->GetDirectives().Value<TString>("Uri", Uri);
    TaskPathPrefix = section->GetDirectives().Value<TString>("TaskPathPrefix", TaskPathPrefix);
    DismissChatPath = section->GetDirectives().Value<TString>("DismissChatPath", DismissChatPath);
    CloseChatPath = section->GetDirectives().Value<TString>("CloseChatPath", CloseChatPath);
    AddMessagePath = section->GetDirectives().Value<TString>("AddMessagePath", AddMessagePath);
    DeferWithMessagePath = section->GetDirectives().Value<TString>("DeferWithMessagePath", DeferWithMessagePath);
    ForwardMessagesPath = section->GetDirectives().Value<TString>("ForwardMessagesPath", ForwardMessagesPath);
    AttachmentPath = section->GetDirectives().Value<TString>("AttachmentPath", AttachmentPath);
    SelfTvmId = section->GetDirectives().Value<ui32>("SelfTvmId", SelfTvmId);
    DestinationTvmId = section->GetDirectives().Value<ui32>("DestinationTvmId", DestinationTvmId);
    RequestTimeout = section->GetDirectives().Value<TDuration>("RequestTimeout", RequestTimeout);
    ClientType = section->GetDirectives().Value<TString>("ClientType", ClientType);
    if (ClientType != "test") {
        AssertCorrectConfig(!!Uri, "Uri field not defined");
        AssertCorrectConfig(!!TaskPathPrefix, "TaskPathPrefix field not defined");
        AssertCorrectConfig(SelfTvmId, "SelfTvmId field not defined");
        AssertCorrectConfig(DestinationTvmId, "DestinationTvmId field not defined");
    }
    const TYandexConfig::TSectionsMap children = section->GetAllChildren();
    auto it = children.find("RequestConfig");
    if (it != children.end()) {
        RequestConfig.InitFromSection(it->second);
    }
}

void TTaxiChatClientConfig::ToString(IOutputStream& os) const {
    os << "Uri: " << Uri << Endl;
    os << "TaskPathPrefix: " << TaskPathPrefix << Endl;
    os << "DismissChatPath: " << DismissChatPath << Endl;
    os << "CloseChatPath: " << CloseChatPath << Endl;
    os << "AddMessagePath: " << AddMessagePath << Endl;
    os << "DeferWithMessagePath: " << DeferWithMessagePath << Endl;
    os << "ForwardMessagesPath: " << ForwardMessagesPath << Endl;
    os << "AttachmentPath: " << AttachmentPath << Endl;
    os << "SelfTvmId: " << SelfTvmId << Endl;
    os << "DestinationTvmId: " << DestinationTvmId << Endl;
    os << "RequestTimeout: " << RequestTimeout << Endl;
    os << "ClientType: " << ClientType << Endl;
    os << "<RequestConfig>" << Endl;
    RequestConfig.ToString(os);
    os << "</RequestConfig>" << Endl;
}

TTaxiChatClientConfig TTaxiChatClientConfig::ParseFromString(const TString& configStr) {
    TTaxiChatClientConfig result;
    TAnyYandexConfig config;
    CHECK_WITH_LOG(config.ParseMemory(configStr.data()));
    result.Init(config.GetRootSection());
    return result;
}
