#pragma once

#include <rtline/library/deprecated/async_impl/config.h>
#include <rtline/util/types/accessor.h>

class TTaxiChatClientConfig {
    R_FIELD(TString, Uri, "");
    R_FIELD(TString, TaskPathPrefix, "/v1/tasks/");
    R_FIELD(TString, DismissChatPath, "dismiss");
    R_FIELD(TString, CloseChatPath, "close");
    R_FIELD(TString, AddMessagePath, "communicate");
    R_FIELD(TString, DeferWithMessagePath, "comment");
    R_FIELD(TString, ForwardMessagesPath, "forward_messages");
    R_FIELD(TString, AttachmentPath, "attachment_with_tvm");
    R_FIELD(ui32, SelfTvmId, 0);
    R_FIELD(ui32, DestinationTvmId, 0);
    R_FIELD(TDuration, RequestTimeout, TDuration::Seconds(20));
    R_FIELD(NSimpleMeta::TConfig, RequestConfig);
    R_FIELD(TString, ClientType, "test");

public:
    static TTaxiChatClientConfig ParseFromString(const TString& configStr);
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;
};
