#include "config.h"

#include <util/stream/file.h>

void TTaxiModuleConfig::Init(const TYandexConfig::Section& componentSection) {
    const TYandexConfig::Directives& dir = componentSection.GetDirectives();
    StatusHost = dir.Value("StatusHost", StatusHost);
    StatusPort = dir.Value("StatusPort", StatusPort);
    StatusUri = dir.Value("StatusUri", StatusUri);
    ClientId = dir.Value("ClientId", ClientId);
    UseHttps = dir.Value<bool>("UseHttps", UseHttps);
    TripInfoTimeout = dir.Value<TDuration>("TripInfoTimeout", TripInfoTimeout);

    if (!ApiKey) {
        ApiKey = dir.Value("ApiKey", ApiKey);
    }
    if (!ApiKey) {
        AuthPath = dir.Value("Auth", AuthPath);
        AssertCorrectConfig(AuthPath.Exists(), "Can't read auth info from " + AuthPath.GetPath());
        ApiKey = Strip(TIFStream(AuthPath).ReadAll());
    }

    AssertCorrectConfig(!ApiKey.empty(), "Empty api key");
    AssertCorrectConfig(!ClientId.empty(), "Empty clientId key");
}

void TTaxiModuleConfig::ToString(IOutputStream& so) const {
    so << "StatusHost: " << StatusHost << Endl;
    so << "StatusPort: " << StatusPort << Endl;
    so << "StatusUri: " << StatusUri << Endl;
    if (AuthPath) {
        so << "Auth: " << AuthPath << Endl;
    }
    so << "ClientId: " << ClientId << Endl;
    so << "UseHttps: " << UseHttps << Endl;
    so << "TripInfoTimeout: " << TripInfoTimeout << Endl;
}
