#pragma once

#include "config.h"

#include <drive/backend/logging/events.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/tvmauth/client/facade.h>

#include <rtline/library/json/field.h>
#include <rtline/util/network/neh.h>
#include <rtline/util/types/accessor.h>

#include <util/datetime/base.h>

class TTaxiDriverProfilesClient {
public:
    struct TRecognizedParkDriverProfileId {
        TString parkId;
        TString driverProfileId;
    };
    enum class EWorkStatus {
        Working = 0 /* "working" */,
        NotWorking = 1 /* "not_working" */,
        Fired = 2 /* "fired" */,
    };
    struct TRecognizedFullName {
        TString FirstName;
        TString MiddleName;
        TString LastName;
    };
    class TRecognizedData {
        R_FIELD(EWorkStatus, WorkStatus);
        R_FIELD(TRecognizedFullName, FullName);
        R_FIELD(TInstant, HireDate);
        R_OPTIONAL(TString, FireDate);
    };
    class TRecognizedProfile {
        R_FIELD(TRecognizedParkDriverProfileId, ParkDriverProfileId);
        R_FIELD(TString, Revision);
        R_FIELD(bool, IsDeleted, false);
        R_FIELD(TRecognizedData, Data);
    };
    class TRecognizedProfilesByParkIdCarId {
        R_FIELD(TString, ParkIdCarId);
        R_FIELD(TVector<TRecognizedProfile>, Profiles);
    };
    class TRecognizedProfilesByParkIdCarIds {
        R_FIELD(TVector<TRecognizedProfilesByParkIdCarId>, RecognizedProfilesByParkIdCarId);
    };
    class TRequestParams {
        R_FIELD(TSet<TString>, ParkIdCarIdInSet);
        R_FIELD(TSet<TString>, Projection);

    public:
        NJson::TJsonValue ToJson() const;
    };

public:
    TTaxiDriverProfilesClient(const TTaxiDriverProfilesConfig& config, TAtomicSharedPtr<NTvmAuth::TTvmClient> tvm = nullptr);
    NThreading::TFuture<TRecognizedProfilesByParkIdCarIds> GetParkDriverProfileIds(const TRequestParams& requestParams, TAtomicSharedPtr<NDrive::TEventLog::TState> eventLogState = nullptr) const;

private:
    NNeh::THttpRequest CreateRequest() const;

private:
    const TTaxiDriverProfilesConfig& Config;
    THolder<NNeh::THttpClient> Client;
    TAtomicSharedPtr<NTvmAuth::TTvmClient> Tvm;
};
