#include "config.h"

#include <library/cpp/mediator/global_notifications/system_status.h>

#include <util/stream/file.h>

void TTaxiDriverProfilesConfig::Init(const TYandexConfig::Section* section) {
    Uri = section->GetDirectives().Value<TString>("Uri", Uri);
    EndpointParkIdCarId = section->GetDirectives().Value<TString>("EndpointParkIdCarId", EndpointParkIdCarId);
    EndpointParkDriverProfileId = section->GetDirectives().Value<TString>("EndpointParkDriverProfileId", EndpointParkDriverProfileId);
    Consumer = section->GetDirectives().Value<TString>("Consumer", Consumer);
    SelfTvmId = section->GetDirectives().Value<ui32>("SelfTvmId", SelfTvmId);
    DestinationTvmId = section->GetDirectives().Value<ui32>("DestinationTvmId", DestinationTvmId);
    RequestTimeout = section->GetDirectives().Value<TDuration>("RequestTimeout", RequestTimeout);
    AssertCorrectConfig(!!Uri, "Uri field not defined");
    AssertCorrectConfig(!!EndpointParkIdCarId, "EndpointParkIdCarId field not defined");
    AssertCorrectConfig(!!EndpointParkDriverProfileId, "EndpointParkDriverProfileId field not defined");
    AssertCorrectConfig(SelfTvmId, "SelfTvmId field not defined");
    AssertCorrectConfig(DestinationTvmId, "DestinationTvmId field not defined");
    const TYandexConfig::TSectionsMap children = section->GetAllChildren();
    auto it = children.find("RequestConfig");
    if (it != children.end()) {
        RequestConfig.InitFromSection(it->second);
    }
}

void TTaxiDriverProfilesConfig::ToString(IOutputStream& os) const {
    os << "Uri: " << Uri << Endl;
    os << "EndpointParkIdCarId: " << EndpointParkIdCarId << Endl;
    os << "EndpointParkDriverProfileId: " << EndpointParkDriverProfileId << Endl;
    os << "Consumer: " << Consumer << Endl;
    os << "SelfTvmId: " << SelfTvmId << Endl;
    os << "DestinationTvmId: " << DestinationTvmId << Endl;
    os << "RequestTimeout: " << RequestTimeout << Endl;
    os << "<RequestConfig>" << Endl;
    RequestConfig.ToString(os);
    os << "</RequestConfig>" << Endl;
}

TTaxiDriverProfilesConfig TTaxiDriverProfilesConfig::ParseFromString(const TString& configStr) {
    TTaxiDriverProfilesConfig result;
    TAnyYandexConfig config;
    CHECK_WITH_LOG(config.ParseMemory(configStr.data()));
    result.Init(config.GetRootSection());
    return result;
}
