#pragma once

#include <library/cpp/yconf/conf.h>

#include <rtline/library/metasearch/simple/config.h>
#include <rtline/util/types/accessor.h>

class TTaxiDriverProfilesConfig {
    R_FIELD(TString, Uri, "http://driver-profiles.taxi.tst.yandex.net");
    R_FIELD(TString, EndpointParkIdCarId, "/v1/vehicle_bindings/drivers/retrieve_by_park_id_car_id");
    R_FIELD(TString, EndpointParkDriverProfileId, "/v1/identity-docs/retrieve_by_park_driver_profile_id");
    R_FIELD(TString, Consumer, "ext-drive-backend");
    R_FIELD(ui32, SelfTvmId, 0);
    R_FIELD(ui32, DestinationTvmId, 0);
    R_FIELD(TDuration, RequestTimeout, TDuration::Seconds(60));
    R_FIELD(NSimpleMeta::TConfig, RequestConfig);

public:
    static TTaxiDriverProfilesConfig ParseFromString(const TString& configStr);
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;
};
