#pragma once

#include "config.h"

#include <drive/backend/logging/events.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/tvmauth/client/facade.h>

#include <rtline/library/json/field.h>
#include <rtline/util/network/neh.h>

class TTaxiDriverStatusClient {
public:
    class TRecognizedOrder {
        R_FIELD(TString, Id);
        R_FIELD(TString, Status);
    };
    enum class EStatus {
        Offline = 0 /* "offline" */,
        Online = 1 /* "online" */,
        Busy = 2 /* "busy" */,
    };
    class TRecognizedStatus {
        R_FIELD(TString, ParkId);
        R_FIELD(TString, DriverId);
        R_FIELD(EStatus, Status);
        R_FIELD(i64, UpdatedTS, -1);
        R_FIELD(TVector<TRecognizedOrder>, Orders);
    };
    class TRecognizeStatuses {
        R_FIELD(TVector<TRecognizedStatus>, RecognizedStatuses);
    };
    struct TParkIdDriverId {
        TString ParkId;
        TString DriverId;
    public:
        bool operator<(const TParkIdDriverId& other) const {
            return std::tie(this->ParkId, this->DriverId) <
                std::tie(other.ParkId, other.DriverId);
        }
    };
    class TRequestParams {
        R_FIELD(TSet<TParkIdDriverId>, ParkIdDrivedIds);
    public:
        NJson::TJsonValue ToJson() const;
    };

public:
    TTaxiDriverStatusClient(const TTaxiDriverStatusConfig& config, TAtomicSharedPtr<NTvmAuth::TTvmClient> tvm = nullptr);

    NThreading::TFuture<TTaxiDriverStatusClient::TRecognizeStatuses> GetDriversStatuses(const TRequestParams& requestParams, TAtomicSharedPtr<NDrive::TEventLog::TState> eventLogState = nullptr) const;
private:
    NNeh::THttpRequest CreateRequest() const;

private:
    const TTaxiDriverStatusConfig& Config;
    THolder<NNeh::THttpClient> Client;
    TAtomicSharedPtr<NTvmAuth::TTvmClient> Tvm;
};
