#pragma once

#include <library/cpp/yconf/conf.h>

#include <rtline/library/metasearch/simple/config.h>
#include <rtline/util/types/accessor.h>

class TTaxiDriverStatusConfig {
    R_FIELD(TString, Uri, "http://driver-status.taxi.tst.yandex.net");
    R_FIELD(TString, Endpoint, "/v2/statuses");
    R_FIELD(TString, Consumer, "ext-drive-backend");
    R_FIELD(ui32, SelfTvmId, 0);
    R_FIELD(ui32, DestinationTvmId, 0);
    R_FIELD(TDuration, RequestTimeout, TDuration::Seconds(60));
    R_FIELD(NSimpleMeta::TConfig, RequestConfig);

public:
    static TTaxiDriverStatusConfig ParseFromString(const TString& configStr);
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;
};
