#pragma once

#include "config.h"

#include <drive/library/cpp/tracks/track.h>

#include <rtline/util/network/neh.h>
#include <rtline/util/types/expected.h>
#include <library/cpp/tvmauth/client/facade.h>

class TTaxiTrackStoryClient {
public:
    TTaxiTrackStoryClient(const TTaxiTrackStoryConfig& config, TAtomicSharedPtr<NTvmAuth::TTvmClient> tvmClient)
        : Config(config)
        , TvmClient(tvmClient)
    {
        Agent = MakeHolder<NNeh::THttpClient>(Config.GetUri());
    }

    NThreading::TFuture<NDrive::TTrack> GetTrack(const TString& imei, TInstant since, TInstant until) const;
    NThreading::TFuture<NDrive::TTrack> GetCameraTrack(const TString& uuid,const TString& dbid, TInstant since, TInstant until) const;
    TDuration GetMaxInterval() const;
    TDuration GetCameraMaxInterval() const;

private:
    NNeh::THttpRequest CreateRequest(const TString& imei, TInstant since, TInstant until) const;
    NNeh::THttpRequest CreateCameraRequest(const TString& uuid,const TString& dbid, TInstant since, TInstant untill) const;

    THolder<NNeh::THttpClient> Agent;
    const TTaxiTrackStoryConfig& Config;
    TAtomicSharedPtr<NTvmAuth::TTvmClient> TvmClient;
};
