#include "config.h"

#include <library/cpp/mediator/global_notifications/system_status.h>

void TTaxiTrackStoryConfig::Init(const TYandexConfig::Section& section) {
    Uri = section.GetDirectives().Value<TString>("Uri", Uri);
    GetTrackPath = section.GetDirectives().Value<TString>("GetTrackPath", GetTrackPath);
    GetCameraTrackPath = section.GetDirectives().Value<TString>("GetCameraTrackPath", GetCameraTrackPath);
    SelfTvmId = section.GetDirectives().Value<ui32>("SelfTvmId", SelfTvmId);
    DestinationTvmId = section.GetDirectives().Value<ui32>("DestinationTvmId", DestinationTvmId);
    CameraDestinationTvmId = section.GetDirectives().Value<ui32>("CameraDestinationTvmId", CameraDestinationTvmId);
    RequestTimeout = section.GetDirectives().Value<TDuration>("RequestTimeout", RequestTimeout);
    MaxInterval = section.GetDirectives().Value<TDuration>("MaxInterval", MaxInterval);
    CameraMaxInterval = section.GetDirectives().Value<TDuration>("CameraMaxInterval", CameraMaxInterval);
    AssertCorrectConfig(!!Uri, "Uri field not defined");
    AssertCorrectConfig(!!GetTrackPath, "GetTrackPath field not defined");
    AssertCorrectConfig(SelfTvmId, "SelfTvmId field not defined");
    AssertCorrectConfig(DestinationTvmId, "DestinationTvmId field not defined");
}

void TTaxiTrackStoryConfig::ToString(IOutputStream& os) const {
    os << "Uri: " << Uri << Endl;
    os << "GetTrackPath: " << GetTrackPath << Endl;
    os << "GetCameraTrackPath: " << GetCameraTrackPath << Endl;
    os << "SelfTvmId: " << SelfTvmId << Endl;
    os << "DestinationTvmId: " << DestinationTvmId << Endl;
    os << "CameraDestinationTvmId: " << CameraDestinationTvmId << Endl;
    os << "RequestTimeout: " << RequestTimeout << Endl;
    os << "MaxInterval: " << MaxInterval << Endl;
    os << "CameraMaxInterval: " << CameraMaxInterval << Endl;
}

TTaxiTrackStoryConfig TTaxiTrackStoryConfig::ParseFromString(const TString& configStr) {
    TTaxiTrackStoryConfig result;
    TAnyYandexConfig config;
    CHECK_WITH_LOG(config.ParseMemory(configStr.data()));
    result.Init(*config.GetRootSection());
    return result;
}
