#pragma once

#include <library/cpp/yconf/conf.h>

#include <rtline/library/metasearch/simple/config.h>
#include <rtline/util/types/accessor.h>

class TTaxiTrackStoryConfig {
    R_FIELD(TString, Uri, "http://driver-trackstory.taxi.tst.yandex.net");
    R_FIELD(TString, GetTrackPath, "/get_track");
    R_FIELD(TString, GetCameraTrackPath, "/camera/track");
    R_FIELD(ui32, SelfTvmId, 0);
    R_FIELD(ui32, DestinationTvmId, 0);
    R_FIELD(ui32, CameraDestinationTvmId, 0);
    R_FIELD(TDuration, RequestTimeout, TDuration::Seconds(1));
    R_FIELD(TDuration, MaxInterval, TDuration::Hours(2));
    R_FIELD(TDuration, CameraMaxInterval, TDuration::Hours(1));

public:
    static TTaxiTrackStoryConfig ParseFromString(const TString& configStr);
    void Init(const TYandexConfig::Section& section);
    void ToString(IOutputStream& os) const;
};
