#pragma once

#include <rtline/library/json/field.h>
#include <rtline/util/network/neh.h>

namespace NDrive {
    class TTaxiFleetClient {
    public:
        struct TCar {
            TMaybe<TString> Id;
            TVector<TString> Amenities;
            TVector<TString> Categories;
            TString Brand;
            TString Callsign;
            TString Color;
            TString Model;
            TString Number;
            TString Status;
            TString Transmission = "automatic";
            double Mileage = 0;
            ui64 BoosterCount = 0;
            ui64 Year = 0;
            TMaybe<TString> VIN;
            TMaybe<TString> STS;

            DECLARE_FIELDS(
                Field(Id, "id"),
                Field(Amenities, "amenities"),
                Field(Categories, "categories"),
                Field(Brand, "brand"),
                Field(Callsign, "callsign"),
                Field(Color, "color"),
                Field(Model, "model"),
                Field(Number, "number"),
                Field(Status, "status"),
                Field(Transmission, "transmission"),
                Field(Mileage, "mileage"),
                Field(BoosterCount, "booster_count"),
                Field(Year, "year"),
                Field(VIN, "vin"),
                Field(STS, "registration_cert")
            );
        };
        using TCars = TVector<TCar>;
        using TOptionalCar = TMaybe<TCar>;

        struct TOptions {
            TString Endpoint = "https://fleet-api.taxi.tst.yandex.net";
        };

        struct TRequest {
            TString ClientId;
            TString ParkId;
            TString Token;
            TDuration Timeout = TDuration::Seconds(7);
        };

    public:
        TTaxiFleetClient(const TOptions& options);

        NThreading::TFuture<TCars> ListCars(const TRequest& request, const TString& searchText = {}) const;
        NThreading::TFuture<TCar> CreateCar(const TCar& car, const TString idempotencyToken, const TRequest& request);
        NThreading::TFuture<TCar> UpdateCar(const TCar& car, const TRequest& request);
        NThreading::TFuture<TOptionalCar> GetActiveCar(const TString& driverProfileId, const TRequest& request) const;
        NThreading::TFuture<TOptionalCar> GetCarByDriveId(const TString& id, const TRequest& request) const;
        NThreading::TFuture<TOptionalCar> GetCarByNumber(const TString& number, const TRequest& request) const;
        NThreading::TFuture<void> Link(const TString& carId, const TString& driverProfileId, const TRequest& request);

    private:
        NNeh::THttpRequest CreateRequest(const TRequest& request) const;

    private:
        NNeh::THttpClient Client;
    };
}
