#include "client.h"

#include <library/cpp/testing/unittest/registar.h>

#include <util/system/env.h>

namespace {
    auto CreateClient() {
        NDrive::TTaxiFleetClient::TOptions options;
        return NDrive::TTaxiFleetClient(options);
    }
    auto CreateRequest() {
        NDrive::TTaxiFleetClient::TRequest request;
        request.ClientId = "svshevtsov";
        request.ParkId = "7ad36bc7560449998acbe2c57a75c293";
        request.Token = GetEnv("TAXI_FLEET_TOKEN");
        UNIT_ASSERT(request.Token);
        return request;
    }
}

Y_UNIT_TEST_SUITE(TaxiFleet) {
    Y_UNIT_TEST(ListCars) {
        auto client = CreateClient();
        auto request = CreateRequest();
        auto asyncCars = client.ListCars(request);
        auto cars = asyncCars.GetValueSync();
        UNIT_ASSERT(!cars.empty());
        for (auto&& car : cars) {
            UNIT_ASSERT(car.Id);
            Cerr << NJson::ToJson(car).GetStringRobust() << Endl;
        }
    }

    Y_UNIT_TEST(ActiveCar) {
        auto client = CreateClient();
        auto request = CreateRequest();
        auto driverId = TString("9b17db0cb1f24a38a5c3c8b4f6e4f63b");
        auto asyncCar = client.GetActiveCar(driverId, request);
        auto car = asyncCar.GetValueSync();
        UNIT_ASSERT(car);
        UNIT_ASSERT(car->Id);
        Cerr << NJson::ToJson(car).GetStringRobust() << Endl;

        auto asyncLink = client.Link(*car->Id, driverId, request);
        asyncLink.GetValueSync();
    }

    Y_UNIT_TEST(UpdateCar) {
        auto client = CreateClient();
        auto request = CreateRequest();
        auto asyncCars = client.ListCars(request);
        auto cars = asyncCars.GetValueSync();
        UNIT_ASSERT(!cars.empty());
        auto car = cars[0];
        car.Callsign = "FUD";
        car.Color = "Красный";
        car.Status = "working";
        car.Year = 1991;
        auto asyncUpdatedCar = client.UpdateCar(car, request);
        auto updatedCar = asyncUpdatedCar.GetValueSync();
        UNIT_ASSERT(car.GetFields() == updatedCar.GetFields());

        auto asyncCarAgain = client.GetCarByNumber(car.Number, request);
        auto carAgain = asyncCarAgain.GetValueSync();
        UNIT_ASSERT(carAgain);
        UNIT_ASSERT(car.GetFields() == carAgain->GetFields());
    }
}
