#pragma once

#include "config.h"

#include <drive/library/cpp/threading/future.h>

#include <drive/backend/logging/events.h>

#include <library/cpp/tvmauth/client/facade.h>

#include <rtline/library/json/field.h>
#include <rtline/util/network/neh.h>

class TTaxiFleetVehiclesClient {
public:
    class TRecognizedData {
        R_FIELD(TString, ParkId);
        R_FIELD(TString, CarId);
        R_FIELD(TString, Color);
        R_FIELD(TString, Number);
        R_FIELD(TString, NumberNormalized);
        R_FIELD(TString, Vin);
        R_FIELD(TString, Callsign);
        R_FIELD(TString, Model);
        R_FIELD(TString, Brand);
        R_FIELD(TString, Year);
        R_FIELD(TString, Transmission);
        R_FIELD(TString, Status);
        R_FIELD(i32, Mileage, -1);
        R_FIELD(TString, CarrierPermitOwnerId);
        R_FIELD(TString, BodyNumber);
        R_FIELD(TString, EuroCarSegment);
        R_FIELD(TString, RegistrationCert);
        R_FIELD(TString, CertVerification);
        R_FIELD(TString, Description);
    };
    class TRecognizedVehicle {
        R_FIELD(TString, ParkIdCarId);
        R_FIELD(TString, Revision);
        R_FIELD(TRecognizedData, Data);
    };
    class TRecognizedVehicles {
        R_FIELD(TVector<TRecognizedVehicle>, RecognizedVehicle);
    };
    class TRequestParams {
        R_FIELD(TSet<TString>, Numbers);
        R_FIELD(TSet<TString>, Projection);

    public:
        NJson::TJsonValue ToJson() const;
    };

public:
    TTaxiFleetVehiclesClient(const TTaxiFleetVehiclesConfig& config, TAtomicSharedPtr<NTvmAuth::TTvmClient> tvm = nullptr);

    NThreading::TFuture<TRecognizedVehicles> GetCarsByNumbers(const TRequestParams& requestParams, TAtomicSharedPtr<NDrive::TEventLog::TState> eventLogState = nullptr) const;

private:
    NNeh::THttpRequest CreateRequest() const;

private:
    const TTaxiFleetVehiclesConfig& Config;
    THolder<NNeh::THttpClient> Client;
    TAtomicSharedPtr<NTvmAuth::TTvmClient> Tvm;
};
