#pragma once

#include <library/cpp/yconf/conf.h>

#include <rtline/library/metasearch/simple/config.h>
#include <rtline/util/types/accessor.h>

class TTaxiFleetVehiclesConfig {
    R_FIELD(TString, Uri, "http://fleet-vehicles.taxi.tst.yandex.net");
    R_FIELD(TString, Endpoint, "/v1/vehicles/retrieve_by_number_with_normalization");
    R_FIELD(TString, Consumer, "ext-drive-backend");
    R_FIELD(ui32, SelfTvmId, 0);
    R_FIELD(ui32, DestinationTvmId, 0);
    R_FIELD(TDuration, RequestTimeout, TDuration::Seconds(60));
    R_FIELD(NSimpleMeta::TConfig, RequestConfig);

public:
    static TTaxiFleetVehiclesConfig ParseFromString(const TString& configStr);
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;
};
