#pragma once

#include <drive/library/cpp/auth/tvm.h>
#include <rtline/util/network/neh.h>

namespace NDrive {
    class TTaxiPromocodesClient {
    public:
        struct TOptions {
            TString Endpoint = "https://coupons.taxi.tst.yandex.net";
            TDuration Timeout = TDuration::Seconds(1);
        };
        struct TRequestData {
            TString YandexUid;
            TString SeriesId;
            TString Token;
            TString BrandName = "yataxi";
            TInstant ExpireAt;

            NJson::TJsonValue GetGenerateRequestData() const;

        };

        struct TPromocode {
            TString Promocode;
        };

        TTaxiPromocodesClient(const TOptions& options, TMaybe<TTvmAuth> tvmAuth);

        NThreading::TFuture<TString> GeneratePromocode(const TRequestData& requestData) const;

        TDuration GetTimeout() const;

    private:
        static void CheckReply(const NUtil::THttpReply& reply);

    private:
        THolder<NNeh::THttpClient> Client;
        TOptions Options;
        TMaybe<TTvmAuth> TvmAuth;
    };
}
