#include "config.h"

namespace NDrive {
    void TTaxiPromocodesClientConfig::Init(const TYandexConfig::Section* section) {
        Y_ENSURE_BT(section);
        const auto& directives = section->GetDirectives();
        Options.Endpoint = directives.Value("Endpoint", Options.Endpoint);
        Options.Timeout = directives.Value("RequestTimeout", Options.Timeout);
        SelfClientId = directives.Value("SelfClientId", SelfClientId);
        DestinationTvmId = directives.Value("DestinationTvmId", DestinationTvmId);
    }

    void TTaxiPromocodesClientConfig::ToString(IOutputStream& os) const {
        os << "Endpoint: " << Options.Endpoint << Endl;
        os << "RequestTimeout: " << Options.Timeout << Endl;
        os << "SelfClientId: " << SelfClientId << Endl;
        os << "DestinationTvmId: " << DestinationTvmId << Endl;
    }

}
