#pragma once

#include "config.h"
#include "taxi_report.h"

#include <rtline/library/geometry/coord.h>

#include <library/cpp/json/json_writer.h>


class TDriveReply {
    struct TCarInfo {
        TCarInfo(const TGeoCoord& location, const TString status, const TTaxiPriceReport& taxiInfo)
            : Location(location)
            , TaxiInfo(taxiInfo)
            , Description(status) {}

        void ToJson(NJson::TJsonValue& json) {
            json["location"] = ToString(Location.X) + " " + ToString(Location.Y);
            json["description"] = Description;
            json["taxi_available"] = "yes";
            json["taxi_price"] = TaxiInfo.GetPrice();
            json["taxi_waiting_time"] = TaxiInfo.GetWaitingTime();
        }

        TGeoCoord Location;
        TTaxiPriceReport TaxiInfo;
        TString Description;
    };

public:
    void AddCar(const TGeoCoord& location, const TString status, const TTaxiPriceReport& taxiInfo) {
        CarsInfo.emplace_back(TCarInfo(location, status, taxiInfo));
    }

    void ToJson(NJson::TJsonValue& json) {
        NJson::TJsonValue cars(NJson::JSON_ARRAY);
        for (auto&& car : CarsInfo) {
            NJson::TJsonValue carInfo;
            car.ToJson(carInfo);
            cars.AppendValue(carInfo);
        }
        json["cars"] = cars;
    }

private:
    TVector<TCarInfo> CarsInfo;
};
