#include "request.h"
#include "taxi_report.h"

#include <library/cpp/logger/global/global.h>
#include <library/cpp/http/io/stream.h>
#include <util/stream/mem.h>

const TString TTaxiRequest::ECONOM_CLASS = "econom";
const TString TTaxiRequest::COMFORT_CLASS = "business"; // It is should be OK.
const TString TTaxiRequest::COMFORT_PLUS_CLASS = "comfortplus";
const TString TTaxiRequest::BUSINESS_CLASS = "vip";

TSimpleTaxiReply::TSimpleTaxiReply(NNeh::THandleRef handle, TDuration timeout)
    : NRTLine::TAsyncReplyBase(handle, timeout)
{
}

bool TSimpleTaxiReply::ParseRawReply(const TString& rawData) const {
    DEBUG_LOG << rawData << Endl;
    return !rawData.empty() && Report.Parse(rawData);
}

const TTaxiPriceReport& TSimpleTaxiReply::GetReport() const {
    Fetch();
    return Report;
}

TSimpleTaxiClient::TSimpleTaxiClient(const TTaxiModuleConfig& config)
    : Config(config)
    , RequestBase("full" + TString(Config.UseHttps ? "s" : "") + "://" + Config.StatusHost + ":" + ToString(Config.StatusPort))
{
}

TSimpleTaxiReply::TPtr TSimpleTaxiClient::SendRequest(const TTaxiRequest& request, TDuration timeout) const {
    DEBUG_LOG << "request=" << RequestBase  << request.Serialize(Config.ClientId) << Endl;
    NNeh::TMessage message = NNeh::TMessage::FromString(RequestBase);

    TStringStream ss;
    TStringBuf CrLf = "\r\n";
    ss << "GET /"sv << Config.StatusUri << request.Serialize(Config.ClientId) << " HTTP/1.1"sv << CrLf;
    ss << "Host: "sv << Config.StatusHost << ":"sv << Config.StatusPort << CrLf;
    ss << "YaTaxi-Api-Key: "sv << Config.ApiKey;
    ss << CrLf << CrLf;
    message.Data = ss.Str();

    const NNeh::THandleRef handle = NNeh::Request(message);
    return new TSimpleTaxiReply(handle, timeout);
}
