#pragma once

#include <rtline/library/geometry/coord.h>

#include <rtline/util/network/neh.h>

#include <library/cpp/tvmauth/client/facade.h>

namespace NDrive {
    inline const TString TaxiRouteHistoryProductionEndpoint = "http://stq-agent.taxi.yandex.net";
    inline const NTvmAuth::TTvmId TaxiRouteHistoryProductionClientId = 2013178;

    inline const TString TaxiRouteHistoryTestingEndpoint = "http://stq-agent.taxi.tst.yandex.net";
    inline const NTvmAuth::TTvmId TaxiRouteHistoryTestingClientId = 2013230;

    struct TTaxiRouteHistoryPoint {
    public:
        enum class EType {
            Source /* "src" */,
            Waiting /* "waiting" */,
            DestinationFix /* "dst_fix" */,
            DestinationActual /* "dst_actual" */,
        };

    public:
        TGeoCoord Position;
        EType Type = EType::Source;
    };
    using TTaxiRouteHistoryPoints = TVector<TTaxiRouteHistoryPoint>;

    struct TTaxiRouteHistoryOrder {
        TInstant Created;
        TString Id;
        TString YandexUid;
        TTaxiRouteHistoryPoints Points;
    };

    class TTaxiRouteHistoryClient {
    public:
        struct TOptions {
            NSimpleMeta::TConfig MetaConfig = NSimpleMeta::TConfig::ForRequester();
            TString Endpoint = TaxiRouteHistoryProductionEndpoint;
            TString QueueHandle = "/queue";
            TString QueueName = "routehistory_drive_add";
            TString ReqIdClass = "DRIVE";

            TDuration DefaultTimeout = TDuration::MilliSeconds(500);
            NTvmAuth::TTvmId DestinationClientId = 0;
        };

    public:
        TTaxiRouteHistoryClient(const TOptions& options, TAtomicSharedPtr<NTvmAuth::TTvmClient> tvm = nullptr, TAsyncDelivery::TPtr ad = nullptr);

        NThreading::TFuture<void> Add(const TTaxiRouteHistoryOrder& order, TDuration timeout = TDuration::Zero()) const;

    private:
        NTvmAuth::TTvmId GetDestinationClientId() const;

    private:
        const TOptions Options;

        TAtomicSharedPtr<NNeh::THttpClient> Client;
        TAtomicSharedPtr<NTvmAuth::TTvmClient> Tvm;
    };
}
