#include "client.h"

#include <drive/library/cpp/tvm/logger.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/system/env.h>

Y_UNIT_TEST_SUITE(TaxiRouteHistory) {
    Y_UNIT_TEST(Simple) {
        auto selfClientIdString = GetEnv("TVM_ID");
        Y_ENSURE(selfClientIdString, "TVM_ID is undefined");
        auto selfClientId = FromString<ui32>(selfClientIdString);
        auto secret = GetEnv("TVM_SECRET");
        Y_ENSURE(secret, "TVM_SECRET is undefined");

        NTvmAuth::NTvmApi::TClientSettings clientSettings;
        clientSettings.SetSelfTvmId(selfClientId);
        clientSettings.EnableServiceTicketsFetchOptions(secret, { NDrive::TaxiRouteHistoryTestingClientId });
        auto tvm = MakeAtomicShared<NTvmAuth::TTvmClient>(clientSettings, CreateGlobalTvmLogger());

        NDrive::TTaxiRouteHistoryClient::TOptions options;
        options.Endpoint = NDrive::TaxiRouteHistoryTestingEndpoint;
        NDrive::TTaxiRouteHistoryClient client(options, tvm);

        NDrive::TTaxiRouteHistoryPoint point;
        point.Position = { 37.5, 55.4 };

        NDrive::TTaxiRouteHistoryOrder order;
        order.Created = Now();
        order.Id = "fake";
        order.YandexUid = "42";
        order.Points.push_back(point);

        auto result = client.Add(order);
        result.Wait();
        result.GetValue();
    }
}
