#pragma once

#include <drive/library/cpp/auth/tvm.h>
#include <rtline/util/network/neh.h>

namespace NDrive {

    class TScootersSurge {
    public:
        struct TOptions {
            TString Endpoint = "http://scooters-surge.taxi.yandex.net";
            TDuration RequestTimeout = TDuration::MilliSeconds(200);
        };

        TScootersSurge(const TOptions& options, TMaybe<TTvmAuth> tvmAuth);
        TScootersSurge(const TScootersSurge& other);
        TScootersSurge& operator=(const TScootersSurge& other);

        struct TResult {
            double Value;
            TVector<double> Features;
        };

        NThreading::TFuture<TResult> GetScootersSurge(double latitude, double longitude) const;

    private:
        THolder<NNeh::THttpClient> Client;
        TOptions Options;
        TMaybe<TTvmAuth> TvmAuth;
    };

}
