#pragma once

#include "config.h"
#include "definitions.h"

#include <rtline/util/network/neh.h>
#include <library/cpp/json/json_reader.h>
#include <library/cpp/tvmauth/client/facade.h>

namespace NSignalq = NDrive::NSignalq;

class ITaxiSignalqDrivematicsApiClient {
public:
    virtual ~ITaxiSignalqDrivematicsApiClient() = default;

    static THolder<ITaxiSignalqDrivematicsApiClient> ConstructTaxiSignalqDrivematicsApiClient(const TTaxiSignalqDrivematicsApiConfig& config, TAtomicSharedPtr<NTvmAuth::TTvmClient> TvmClient);
    virtual NThreading::TFuture<NSignalq::TV1StatusesRetrieveResponse> GetSignalqStatuses(const NSignalq::TV1StatusesRetrieveRequest& requestParams) const = 0;
    virtual NThreading::TFuture<NSignalq::TV1EventsRetrieveResponse> GetSignalqEvents(const NSignalq::TV1EventsRetrieveRequest& requestParams) const = 0;
    virtual NThreading::TFuture<NSignalq::TV1DeviceStatusHistoryIntervalsResponse> GetSignalqStatusHistoryIntervals(const NSignalq::TV1DeviceStatusHistoryIntervalsRequest& requestParams) const = 0;
    virtual NThreading::TFuture<NJson::TJsonValue> GetSignalqStatusHistoryIntervalsJson(const NSignalq::TV1DeviceStatusHistoryIntervalsRequest& requestParams) const = 0;
    virtual NThreading::TFuture<NSignalq::TV1EventsMediaPresignedUrlsGenerateResponse> GetEventsMediaPresignedUrls(const NSignalq::TV1EventsMediaPresignedUrlsGenerateRequest& requestParams) const = 0;
    virtual NThreading::TFuture<NSignalq::TV1EventRaiseUrlsGenerateResponse> GetSignalqEventRaiseUrls(const NSignalq::TV1EventRaiseUrlsGenerateRequest& requestParams) const = 0;
    virtual NThreading::TFuture<void> SetEventResolutionInFleet(const NSignalq::TV1EventResolutionRequest& requestParams) const = 0;
    virtual NThreading::TFuture<NSignalq::TV1DeviceParkGetResponse> GetPark(const NSignalq::TV1DeviceParkGetRequest& requestParams) const = 0;
};

class TTaxiSignalqDrivematicsApiClient: public ITaxiSignalqDrivematicsApiClient {
public:
    TTaxiSignalqDrivematicsApiClient(const TTaxiSignalqDrivematicsApiConfig & config, TAtomicSharedPtr<NTvmAuth::TTvmClient> tvmClient)
        : Config(config)
        , TvmClient(tvmClient)
    {
        CHECK_WITH_LOG(tvmClient);
        Client = MakeHolder<NNeh::THttpClient>(Config.GetUri(), Config.GetRequestConfig());
    }
    NThreading::TFuture<NSignalq::TV1StatusesRetrieveResponse> GetSignalqStatuses(const NSignalq::TV1StatusesRetrieveRequest& requestParams) const override;
    NThreading::TFuture<NSignalq::TV1EventsRetrieveResponse> GetSignalqEvents(const NSignalq::TV1EventsRetrieveRequest& requestParams) const override;
    NThreading::TFuture<NSignalq::TV1DeviceStatusHistoryIntervalsResponse> GetSignalqStatusHistoryIntervals(const NSignalq::TV1DeviceStatusHistoryIntervalsRequest& requestParams) const override;
    NThreading::TFuture<NJson::TJsonValue> GetSignalqStatusHistoryIntervalsJson(const NSignalq::TV1DeviceStatusHistoryIntervalsRequest& requestParams) const override;
    NThreading::TFuture<NSignalq::TV1EventsMediaPresignedUrlsGenerateResponse> GetEventsMediaPresignedUrls(const NSignalq::TV1EventsMediaPresignedUrlsGenerateRequest& requestParams) const override;
    NThreading::TFuture<NSignalq::TV1EventRaiseUrlsGenerateResponse> GetSignalqEventRaiseUrls(const NSignalq::TV1EventRaiseUrlsGenerateRequest& requestParams) const override;
    virtual NThreading::TFuture<void> SetEventResolutionInFleet(const NSignalq::TV1EventResolutionRequest& requestParams) const override;
    virtual NThreading::TFuture<NSignalq::TV1DeviceParkGetResponse> GetPark(const NSignalq::TV1DeviceParkGetRequest& requestParams) const override;

private:
    const TTaxiSignalqDrivematicsApiConfig& Config;
    TAtomicSharedPtr<NNeh::THttpClient> Client;
    TAtomicSharedPtr<NTvmAuth::TTvmClient> TvmClient;
};

class TFakeTaxiSignalqDrivematicsApiClient: public ITaxiSignalqDrivematicsApiClient {
public:
    TFakeTaxiSignalqDrivematicsApiClient() = default;
    NThreading::TFuture<NSignalq::TV1StatusesRetrieveResponse> GetSignalqStatuses(const NSignalq::TV1StatusesRetrieveRequest& requestParams) const override;
    NThreading::TFuture<NSignalq::TV1EventsRetrieveResponse> GetSignalqEvents(const NSignalq::TV1EventsRetrieveRequest& requestParams) const override;
    NThreading::TFuture<NSignalq::TV1DeviceStatusHistoryIntervalsResponse> GetSignalqStatusHistoryIntervals(const NSignalq::TV1DeviceStatusHistoryIntervalsRequest& requestParams) const override;
    NThreading::TFuture<NJson::TJsonValue> GetSignalqStatusHistoryIntervalsJson(const NSignalq::TV1DeviceStatusHistoryIntervalsRequest& requestParams) const override;
    NThreading::TFuture<NSignalq::TV1EventsMediaPresignedUrlsGenerateResponse> GetEventsMediaPresignedUrls(const NSignalq::TV1EventsMediaPresignedUrlsGenerateRequest& requestParams) const override;
    NThreading::TFuture<NSignalq::TV1EventRaiseUrlsGenerateResponse> GetSignalqEventRaiseUrls(const NSignalq::TV1EventRaiseUrlsGenerateRequest& requestParams) const override;
    virtual NThreading::TFuture<void> SetEventResolutionInFleet(const NSignalq::TV1EventResolutionRequest& requestParams) const override;
    virtual NThreading::TFuture<NSignalq::TV1DeviceParkGetResponse> GetPark(const NSignalq::TV1DeviceParkGetRequest& requestParams) const override;

private:
    inline static TString CreateFakePresignedUrl(const TString& s3Path, const TInstant& expiresAt) {
        return s3Path + "&ExpiresAt=" + expiresAt.ToString();
    }
};
