#include "config.h"

#include <library/cpp/mediator/global_notifications/system_status.h>

#include <util/stream/file.h>

void TTaxiSignalqDrivematicsApiConfig::Init(const TYandexConfig::Section* section) {
    Uri = section->GetDirectives().Value<TString>("Uri", Uri);
    V1StatusesRetriveEndpoint = section->GetDirectives().Value<TString>("V1StatusesRetriveEndpoint", V1StatusesRetriveEndpoint);
    V1DeviceStatusHistoryIntervalsEndpoint = section->GetDirectives().Value<TString>("V1DeviceStatusHistoryIntervalsEndpoint", V1DeviceStatusHistoryIntervalsEndpoint);
    V1EventsMediaPresignedUrlsGenerateEndpoint = section->GetDirectives().Value<TString>("V1EventsMediaPresignedUrlsGenerateEndpoint", V1EventsMediaPresignedUrlsGenerateEndpoint);
    V1EventRaiseUrlsGenerateEndpoint = section->GetDirectives().Value<TString>("V1EventRaiseUrlsGenerateEndpoint", V1EventRaiseUrlsGenerateEndpoint);
    V1EventsResolutionsEndpoint = section->GetDirectives().Value<TString>("V1EventsResolutionsEndpoint", V1EventsResolutionsEndpoint);
    V1DeviceGetParkEndpoint = section->GetDirectives().Value<TString>("V1DeviceGetParkEndpoint", V1DeviceGetParkEndpoint);
    SelfTvmId = section->GetDirectives().Value<ui32>("SelfTvmId", SelfTvmId);
    DestinationTvmId = section->GetDirectives().Value<ui32>("DestinationTvmId", DestinationTvmId);
    RequestTimeout = section->GetDirectives().Value<TDuration>("RequestTimeout", RequestTimeout);
    ClientType = section->GetDirectives().Value<TString>("ClientType", ClientType);
    if (ClientType != "fake") {
        AssertCorrectConfig(!!Uri, "Uri field not defined");
        AssertCorrectConfig(SelfTvmId, "SelfTvmId field not defined");
        AssertCorrectConfig(DestinationTvmId, "DestinationTvmId field not defined");
    }
    const TYandexConfig::TSectionsMap children = section->GetAllChildren();
    auto it = children.find("RequestConfig");
    if (it != children.end()) {
        RequestConfig.InitFromSection(it->second);
    }
}

void TTaxiSignalqDrivematicsApiConfig::ToString(IOutputStream& os) const {
    os << "Uri: " << Uri << Endl;
    os << "V1StatusesRetriveEndpoint: " << V1StatusesRetriveEndpoint << Endl;
    os << "V1DeviceStatusHistoryIntervalsEndpoint: " << V1DeviceStatusHistoryIntervalsEndpoint << Endl;
    os << "V1EventsMediaPresignedUrlsGenerateEndpoint: " << V1EventsMediaPresignedUrlsGenerateEndpoint << Endl;
    os << "V1EventRaiseUrlsGenerateEndpoint: " << V1EventRaiseUrlsGenerateEndpoint << Endl;
    os << "V1EventsResolutionsEndpoint: " << V1EventsResolutionsEndpoint << Endl;
    os << "V1DeviceGetParkEndpoint: " << V1DeviceGetParkEndpoint << Endl;
    os << "SelfTvmId: " << SelfTvmId << Endl;
    os << "DestinationTvmId: " << DestinationTvmId << Endl;
    os << "RequestTimeout: " << RequestTimeout << Endl;
    os << "ClientType: " << ClientType << Endl;
    os << "<RequestConfig>" << Endl;
    RequestConfig.ToString(os);
    os << "</RequestConfig>" << Endl;
}

TTaxiSignalqDrivematicsApiConfig TTaxiSignalqDrivematicsApiConfig::ParseFromString(const TString& configStr) {
    TTaxiSignalqDrivematicsApiConfig result;
    TAnyYandexConfig config;
    CHECK_WITH_LOG(config.ParseMemory(configStr.data()));
    result.Init(config.GetRootSection());
    return result;
}
