#pragma once

#include <library/cpp/yconf/conf.h>

#include <rtline/library/metasearch/simple/config.h>
#include <rtline/util/types/accessor.h>


class TTaxiSignalqDrivematicsApiConfig {
    R_FIELD(TString, Uri, "signalq-drivematics-api.taxi.tst.yandex.net");
    R_FIELD(TString, V1StatusesRetriveEndpoint, "/drivematics/signalq-drivematics-api/v1/statuses/retrieve");
    R_FIELD(TString, V1EventsRetrieveEndpoint, "/drivematics/signalq-drivematics-api/v1/events/retrieve");
    R_FIELD(TString, V1DeviceStatusHistoryIntervalsEndpoint, "/drivematics/signalq-drivematics-api/v1/device/status-history/intervals");
    R_FIELD(TString, V1DeviceGetParkEndpoint, "/drivematics/signalq-drivematics-api/v1/device/park");
    R_FIELD(TString, V1EventsMediaPresignedUrlsGenerateEndpoint, "/drivematics/signalq-drivematics-api/v1/events/media-presigned-urls/generate");
    R_FIELD(TString, V1EventRaiseUrlsGenerateEndpoint, "/drivematics/signalq-drivematics-api/v1/event-raise-urls/generate");
    R_FIELD(TString, V1EventsResolutionsEndpoint, "/drivematics/signalq-drivematics-api/v1/events/resolutions");
    R_FIELD(ui32, SelfTvmId, 0);
    R_FIELD(ui32, DestinationTvmId, 2033295);
    R_FIELD(TDuration, RequestTimeout, TDuration::Seconds(1));
    R_FIELD(NSimpleMeta::TConfig, RequestConfig);
    R_FIELD(TString, ClientType, "test");


public:
    static TTaxiSignalqDrivematicsApiConfig ParseFromString(const TString& configStr);
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;
};
