#pragma once

#include <library/cpp/json/json_reader.h>
#include <rtline/library/json/parse.h>
#include <rtline/util/types/accessor.h>

namespace NDrive{
    namespace NSignalq{
        struct TBadRequestException: public yexception {};

        enum class EEventResolution {
            Hide /* "hide" */,
            Delete /* "delete" */,
            WrongEvent /* "wrong_event" */,
            WrongDriver /* "wrong_driver" */,
            SupportApprove /* "support_approve" */
        };

        class TLastLocation {
            R_FIELD(double, Lat, 0.0);
            R_FIELD(double, Lon, 0.0);
            R_FIELD(double, AccuracyM, 0.0);
            R_FIELD(double, SpeedKmph, 0.0);
            R_FIELD(double, DirectionDeg, 0.0);
            R_FIELD(TInstant, UpdateAt);
        };

        class TGnss {
            R_OPTIONAL(double, Lat);
            R_OPTIONAL(double, Lon);
            R_OPTIONAL(double, AccuracyM);
            R_OPTIONAL(double, SpeedKmph);
            R_OPTIONAL(double, DirectionDeg);
        };
        class TGpsPosition {
            R_FIELD(double, Lat, 100000);
            R_FIELD(double, Lon, 100000);
        };
        class TUploadQueue {
            R_FIELD(i64, Photo, -1);
            R_FIELD(i64, Video, -1);
            R_FIELD(i64, Log, -1);
            R_OPTIONAL(i64, Event);
        };
        class TStatus {
            R_FIELD(TInstant, StatusAt);
            R_FIELD(double, CpuTemperature, -1);
            R_FIELD(i64, DiskBytesFreeSpace, -1);
            R_FIELD(i64, DiskBytesTotalSpace, -1);
            R_FIELD(i64, RootBytesFreeSpace, -1);
            R_FIELD(i64, RootBytesTotalSpace, -1);
            R_FIELD(i64, RamBytesFreeSpace, -1);
            R_FIELD(TString, SoftwareVersion);
            R_FIELD(i64, UptimeMs, -1);
            R_OPTIONAL(TGnss, Gnss);
            R_OPTIONAL(TGpsPosition, GpsPosition);
            R_OPTIONAL(TInstant, PositionUpdateAt);
            R_OPTIONAL(TString, SimImsi);
            R_OPTIONAL(TString, SimIccid);
            R_OPTIONAL(TString, SimPhoneNumber);
            R_OPTIONAL(TUploadQueue, UploadQueue);
            R_OPTIONAL(NJson::TJsonValue, States);
        };
        class TEvent {
            R_FIELD(TString, Id);
            R_FIELD(TInstant, At);
            R_FIELD(TString, Type);
            R_OPTIONAL(TGnss, Gnss);
            R_OPTIONAL(TString, S3VideoPath);
            R_OPTIONAL(TString, S3ExternalVideoPath);
            R_OPTIONAL(TString, S3PhotoPath);
            R_OPTIONAL(TString, S3ExternalPhotoPath);
            R_OPTIONAL(bool, Signalled);
        };

        class TV1SignalqSignalCreateItem {
            R_FIELD(TString, SerialNumber);
            R_FIELD(TEvent, Event);
        };

        class TV1SignalqSignalCreateRequestData {
            R_FIELD(TVector<TV1SignalqSignalCreateItem>, Events);
        };

        class TV1StatusesRetrieveResponseItem {
            R_FIELD(TString, SerialNumber);
            R_OPTIONAL(TStatus, Status);
            R_OPTIONAL(TLastLocation, LastLocation);
        };

        class TV1EventsRetrieveResponseItem {
            R_FIELD(TString, SerialNumber);
            R_OPTIONAL(TEvent, Event);
        };

        class TV1StatusesRetrieveRequest {
            R_FIELD(TVector<TString>, SerialNumbers);
        };

        class TV1EventsRetrieveRequest {
            R_FIELD(TVector<TString>, SerialNumbers);
        };

        class TV1StatusesRetrieveResponse {
            R_FIELD(TVector<TV1StatusesRetrieveResponseItem>, Items);
        public:
            class TSerialNumberData {
                R_OPTIONAL(TStatus, Status);
                R_OPTIONAL(TLastLocation, LastLocation);
            };

            using TSerialNumberToDataMap = TMap<TString, TSerialNumberData>;

            TSerialNumberToDataMap BuildSerialNumberToDataMap() const;
        };

        class TV1EventsRetrieveResponse {
            R_FIELD(TVector<TV1EventsRetrieveResponseItem>, Items);
        public:
            class TSerialNumberData {
                R_OPTIONAL(TEvent, Event);
            };
            using TSerialNumberToDataMap = TMap<TString, TSerialNumberData>;
            TSerialNumberToDataMap BuildSerialNumberToDataMap() const;
        };

        class TV1EventWithMedia {
            R_FIELD(TString, SerialNumberEventId);
            R_OPTIONAL(TString, S3VideoPath);
            R_OPTIONAL(TString, S3ExternalVideoPath);
            R_OPTIONAL(TString, S3PhotoPath);
            R_OPTIONAL(TString, S3ExternalPhotoPath);
        };

        class TV1EventsMediaPresignedUrlsGenerateRequest {
            R_FIELD(TVector<TV1EventWithMedia>, Events);
            R_FIELD(TInstant, LinksExpiresAt);
            R_OPTIONAL(bool, OnlyUploaded);
        };

        class TV1EventWithGeneratedUrls {
            R_FIELD(TString, SerialNumberEventId);
            R_OPTIONAL(TString, S3VideoPresignedUrl);
            R_OPTIONAL(TString, S3ExternalVideoPresignedUrl);
            R_OPTIONAL(TString, S3PhotoPresignedUrl);
            R_OPTIONAL(TString, S3ExternalPhotoPresignedUrl);
        };

	    class TV1EventsMediaPresignedUrlsGenerateResponse {
            R_FIELD(TVector<TV1EventWithGeneratedUrls>, Events);
        public:
            class TEventPresignedUrls {
                R_OPTIONAL(TString, S3VideoPresignedUrl);
                R_OPTIONAL(TString, S3ExternalVideoPresignedUrl);
                R_OPTIONAL(TString, S3PhotoPresignedUrl);
                R_OPTIONAL(TString, S3ExternalPhotoPresignedUrl);
                R_FIELD(TInstant, ExpiresAt, TInstant::Zero());
            public:
                NJson::TJsonValue BuildReportJson() const;
            };

            using TSerialNumberEventIdToEventPresignedUrlsMap = TMap<TString, TEventPresignedUrls>;

            TSerialNumberEventIdToEventPresignedUrlsMap BuildSerialNumberEventIdToEventPresignedUrlsMap(const TInstant linksExpiresAt) const;
        };

        class TUrlParameteresItem {
            R_FIELD(TString, SerialNumber);
            R_FIELD(i64, UnixTimestamp, -1);
            R_OPTIONAL(TString, EventType);
        public:
            NJson::TJsonValue ToJson() const;
        };

        class TV1EventRaiseUrlsGenerateRequest {
            R_FIELD(TVector<TUrlParameteresItem>, UrlParameteres);
        public:
            NJson::TJsonValue ToJson() const;
        };

        class TV1EventRaiseUrlsGenerateItem {
            R_FIELD(TString, SerialNumber);
            R_FIELD(i64, UnixTimestamp, -1);
            R_FIELD(TString, Url);
        };

        class TV1EventResolutionRequest {
            R_FIELD(TString, SerialNumber);
            R_FIELD(EEventResolution, Resolution);
            R_FIELD(TString, EventId);
        };

        class TV1EventRaiseUrlsGenerateResponse {
            R_FIELD(TVector<TV1EventRaiseUrlsGenerateItem>, Items);
        public:
            using TSerialNumberUnixTimestampToDataMap = TMap<TString, TString>;

            TSerialNumberUnixTimestampToDataMap BuildSerialNumberUnixTimestampToDataMap() const;
        };

        class TPeriod {
            R_FIELD(TInstant, From);
            R_FIELD(TInstant, To);
        };

        class TV1DeviceStatusHistoryIntervalsRequest {
            R_FIELD(TString, SerialNumber);
            R_OPTIONAL(TPeriod, Period);
            R_OPTIONAL(TString, Cursor);
            R_OPTIONAL(int, StatusesIntervalsLimit);
        };

        class TV1DeviceStatusHistoryInterval {
            R_FIELD(TInstant, StartAt);
            R_FIELD(TInstant, EndAt);
            R_FIELD(TString, Status);
        };

        class TV1DeviceStatusHistoryIntervalsResponse {
            R_FIELD(TVector<TV1DeviceStatusHistoryInterval>, Intervals);
            R_OPTIONAL(TString, Cursor);
        };

        class TErrorResponse {
            R_FIELD(TString, Code);
            R_FIELD(TString, Message);
        };

        class TV1DeviceParkGetRequest {
            R_FIELD(TString, SerialNumber);
        };

        class TV1DeviceParkGetResponse {
            R_FIELD(TString, ParkId);
        };
    } // namespace NSignalq
} // namespace NDrive
