#pragma once

#include <util/generic/string.h>
#include <util/string/cast.h>

namespace NDrive {
    namespace NSignalq {
      inline TString MakeSerialNumberEventId(const TString& serialNumber, const TString& eventId) {
        return serialNumber + "_" + eventId;
      }
      inline TString MakeSerialNumberUnixTimestamp(const TString& serialNumber, const i64 unixTimestamp) {
        return serialNumber + "_" + ToString(unixTimestamp);
      }
    } // namespace NSignalq
} // namespace NDrive
