#pragma once

#include <rtline/util/network/neh.h>

#include <library/cpp/langs/langs.h>
#include <library/cpp/tvmauth/client/facade.h>

#include <util/generic/vector.h>

namespace NDrive {
    struct TTaxiSuggest {
    public:
        struct TElement {
            double Latitude;
            double Longitude;
            TString Text;
            TString Title;
            TString Subtitle;
        };
        using TElements = TVector<TElement>;

    public:
        TElements Elements;
    };

    class TTaxiSuggestClient {
    public:
        struct TOptions {
            NSimpleMeta::TConfig MetaConfig = NSimpleMeta::TConfig::ForRequester();
            TString Endpoint = "http://persuggest.taxi.yandex.net";
            TString ZeroSuggestHandle = "/4.0/persuggest/v1/zerosuggest";
            TString ReqIdClass = "DRIVE";
            TString RequestApplication = "app_name=android,app_brand=yataxi";
            TString YaTaxiPassFlags = "portal";
            TString YaTaxiPhoneId = "dddddddddddddddddddddddd";
            TString YaTaxiUserId = "dddddddddddddddddddddddddddddddd";

            TDuration DefaultTimeout = TDuration::MilliSeconds(500);
            NTvmAuth::TTvmId DestinationClientId = 2015018;
        };

    public:
        TTaxiSuggestClient(const TOptions& options, TAtomicSharedPtr<NTvmAuth::TTvmClient> tvm = nullptr, TAsyncDelivery::TPtr ad = nullptr);

        NThreading::TFuture<TTaxiSuggest> GetZeroSuggest(double latitude, double longitude, TStringBuf uid, TStringBuf userTicket = {}, ELanguage language = LANG_RUS, TDuration timeout = TDuration::Zero()) const;

    private:
        const TOptions Options;

        TAtomicSharedPtr<NNeh::THttpClient> Client;
        TAtomicSharedPtr<NTvmAuth::TTvmClient> Tvm;
    };
}
