#include "client.h"

#include <drive/library/cpp/tvm/logger.h>

#include <library/cpp/testing/unittest/registar.h>

#include <rtline/library/json/cast.h>
#include <rtline/util/algorithm/ptr.h>

#include <util/system/env.h>

Y_UNIT_TEST_SUITE(TaxiSuggest) {
    Y_UNIT_TEST(Simple) {
        auto selfClientIdString = GetEnv("TVM_ID");
        Y_ENSURE(selfClientIdString, "TVM_ID is undefined");
        auto selfClientId = FromString<ui32>(selfClientIdString);
        auto secret = GetEnv("TVM_SECRET");
        Y_ENSURE(secret, "TVM_SECRET is undefined");

        NDrive::TTaxiSuggestClient::TOptions options;

        NTvmAuth::NTvmApi::TClientSettings clientSettings;
        clientSettings.SetSelfTvmId(selfClientId);
        clientSettings.EnableServiceTicketsFetchOptions(secret, { options.DestinationClientId });
        auto tvm = MakeAtomicShared<NTvmAuth::TTvmClient>(clientSettings, CreateGlobalTvmLogger());

        NDrive::TTaxiSuggestClient client(options, tvm);
        auto asyncZeroSuggest = client.GetZeroSuggest(55.736713, 37.640373, {});
        auto zerosuggest = asyncZeroSuggest.ExtractValueSync();
        UNIT_ASSERT(!zerosuggest.Elements.empty());
        for (auto&& i : zerosuggest.Elements) {
            Cout << NJson::ToJson(i).GetStringRobust() << Endl;
        }
    }
}
