#include "config.h"

void TTaxiSupportChatSuggestConfig::Init(const TYandexConfig::Section* section) {
    Uri = section->GetDirectives().Value<TString>("Uri", Uri);
    SupportSuggestPath = section->GetDirectives().Value<TString>("SupportSuggestPath", SupportSuggestPath);
    ProjectId = section->GetDirectives().Value<TString>("ProjectId", ProjectId);
    SelfTvmId = section->GetDirectives().Value<ui32>("SelfTvmId", SelfTvmId);
    DestinationTvmId = section->GetDirectives().Value<ui32>("DestinationTvmId", DestinationTvmId);
    RequestTimeout = section->GetDirectives().Value<TDuration>("RequestTimeout", RequestTimeout);
    AssertCorrectConfig(!!Uri, "Uri field not defined");
    AssertCorrectConfig(!!SupportSuggestPath, "SupportSuggestPath field not defined");
    AssertCorrectConfig(SelfTvmId, "SelfTvmId field not defined");
    AssertCorrectConfig(DestinationTvmId, "DestinationTvmId field not defined");
    const TYandexConfig::TSectionsMap children = section->GetAllChildren();
    auto it = children.find("RequestConfig");
    if (it != children.end()) {
        RequestConfig.InitFromSection(it->second);
    }
}

void TTaxiSupportChatSuggestConfig::ToString(IOutputStream& os) const {
    os << "Uri: " << Uri << Endl;
    os << "SupportSuggestPath: " << SupportSuggestPath << Endl;
    os << "ProjectId: " << ProjectId << Endl;
    os << "SelfTvmId: " << SelfTvmId << Endl;
    os << "DestinationTvmId: " << DestinationTvmId << Endl;
    os << "RequestTimeout: " << RequestTimeout << Endl;
    os << "<RequestConfig>" << Endl;
    RequestConfig.ToString(os);
    os << "</RequestConfig>" << Endl;
}

TTaxiSupportChatSuggestConfig TTaxiSupportChatSuggestConfig::ParseFromString(const TString& configStr) {
    TTaxiSupportChatSuggestConfig result;
    TAnyYandexConfig config;
    CHECK_WITH_LOG(config.ParseMemory(configStr.data()));
    result.Init(config.GetRootSection());
    return result;
}
