#pragma once

#include <rtline/util/network/neh.h>

#include <library/cpp/tvmauth/client/facade.h>
#include <contrib/libs/re2/re2/re2.h>

#include <util/generic/vector.h>

namespace NDrive {

    struct TSupportPrediction {
        public:
            struct TElement {
                TString Topic;
                double Probability;
            };

        public:
            TVector<TElement> Elements;
    };

    using TSupportDialogue = TVector<NJson::TJsonValue>;

    class TTaxiSupportClassifierClient {
    public:
        struct TOptions {
            NSimpleMeta::TConfig MetaConfig = NSimpleMeta::TConfig::ForRequester();
            TString EndPointStable = "http://plotva-ml-l7.taxi.yandex.net";
            TString EndPointTest = "http://plotva-ml-l7.taxi.tst.yandex.net";
            TString Uri = "/yadrive_support/v1";
            
            TDuration DefaultTimeout = TDuration::MilliSeconds(500);
            NTvmAuth::TTvmId DestinationClientIdStable = 2016315;
            NTvmAuth::TTvmId DestinationClientIdTest = 2016313;
            bool IsTest = false;
        };

    public:
        TTaxiSupportClassifierClient(const TOptions& options, TAtomicSharedPtr<NTvmAuth::TTvmClient> tvm = nullptr, TAsyncDelivery::TPtr ad = nullptr);

        NThreading::TFuture<TSupportPrediction> Classify(const TSupportDialogue& dialogue, const TString& userId, const TString& mlRequestId, TDuration timeout = TDuration::Zero()) const;
        TString CleanText(const TString& text) const;

    private:
        TSupportDialogue Preprocess(const TSupportDialogue& dialogue) const;

    private:
        const TOptions Options;

        TAtomicSharedPtr<NNeh::THttpClient> Client;
        TAtomicSharedPtr<NTvmAuth::TTvmClient> Tvm;

        // match attachments ids (like "image:510255:1837bb95dcc16c9a6b7175ecee862709")
        RE2 RegexId;
        // match square brackets tags (like [color=#FFFFFFE6])
        RE2 RegexTag;
        // match some urls
        RE2 RegexUrl;
    };
}
