#include "client.h"

#include <drive/library/cpp/tvm/logger.h>

#include <library/cpp/testing/unittest/registar.h>

#include <rtline/library/json/cast.h>
#include <rtline/util/algorithm/ptr.h>

#include <util/system/env.h>

Y_UNIT_TEST_SUITE(TaxiSupportClassifier) {
    Y_UNIT_TEST(Simple) {
        auto selfClientIdString = GetEnv("TVM_ID");
        Y_ENSURE(selfClientIdString, "TVM_ID is undefined");
        auto selfClientId = FromString<ui32>(selfClientIdString);
        auto secret = GetEnv("TVM_SECRET");
        Y_ENSURE(secret, "TVM_SECRET is undefined");

        NDrive::TTaxiSupportClassifierClient::TOptions options;
        options.IsTest = true;

        NTvmAuth::NTvmApi::TClientSettings clientSettings;
        clientSettings.SetSelfTvmId(selfClientId);
        clientSettings.EnableServiceTicketsFetchOptions(secret, { options.DestinationClientIdTest });
        auto tvm = MakeAtomicShared<NTvmAuth::TTvmClient>(clientSettings, CreateGlobalTvmLogger());

        NDrive::TTaxiSupportClassifierClient client(options, tvm);
        UNIT_ASSERT_VALUES_EQUAL(client.CleanText("url is http://yandex.ru"), "url is");
        UNIT_ASSERT_VALUES_EQUAL(client.CleanText("[color=#FFFFFFE6]Спасибо за фидбек ❤️[/color]"), "Спасибо за фидбек ❤️");
        UNIT_ASSERT_VALUES_EQUAL(client.CleanText("image:510255:1837bb95dcc16c9a6b7175ecee862709,image:510254:bdee3985565575eb46ab63b7998816f0"), "");

        NJson::TJsonValue dialogueTurn;
        dialogueTurn["author_id"] = "user";
        dialogueTurn["message"] = "Hello!";
        NDrive::TSupportDialogue dialogue = {dialogueTurn};
        auto asyncClassifyResult = client.Classify(dialogue, "user-id", "ml-request-id");
        auto classifyResult = asyncClassifyResult.ExtractValueSync();
        UNIT_ASSERT(!classifyResult.Elements.empty());
        Cout << classifyResult.Elements.size() << " elements:\n";
        for (auto&& i : classifyResult.Elements) {
            Cout << NJson::ToJson(i).GetStringRobust() << Endl;
        }
    }
}
