#pragma once

#include <drive/library/cpp/auth/tvm.h>
#include <rtline/library/geometry/coord.h>
#include <rtline/util/network/neh.h>

namespace NDrive {

    class TTaxiSurgeCalculator {
    public:
        struct TOptions {
            TString Endpoint = "http://surge-calculator.taxi.yandex.net";
            TDuration RequestTimeout = TDuration::Seconds(1);
        };

        TTaxiSurgeCalculator(const TOptions& options, TMaybe<TTvmAuth> tvmAuth);

        struct TResult {
            struct TElement {
                TString Name;
                double Value;
            };

            TVector<TElement> Classes;
        };

        NThreading::TFuture<TResult> GetMapSurge(const TGeoCoord& location) const;

    private:
        THolder<NNeh::THttpClient> Client;
        TOptions Options;
        TMaybe<TTvmAuth> TvmAuth;
    };

}
