#include "client.h"

#include <drive/library/cpp/threading/future.h>
#include <drive/library/cpp/tvm/logger.h>

#include <library/cpp/testing/unittest/registar.h>

#include <rtline/library/json/cast.h>
#include <rtline/util/algorithm/ptr.h>

#include <util/system/env.h>

Y_UNIT_TEST_SUITE(TaxiSurgeCalculator) {
    Y_UNIT_TEST(Simple) {
        auto tvmIdString = GetEnv("TVM_ID", "2000615");
        Y_ENSURE(tvmIdString, "TVM_ID is undefined");
        auto tvmId = FromString<ui32>(tvmIdString);
        auto targetTvmIdString = GetEnv("TARGET_TVM_ID", "2019649");
        Y_ENSURE(targetTvmIdString, "TVM_ID is undefined");
        auto targetTvmId = FromString<ui32>(targetTvmIdString);
        auto tvmSecret = GetEnv("TVM_SECRET");
        Y_ENSURE(tvmSecret, "TVM_SECRET is undefined");
        NDrive::TTaxiSurgeCalculator::TOptions options;
        NTvmAuth::NTvmApi::TClientSettings clientSettings;
        clientSettings.SetSelfTvmId(tvmId);
        clientSettings.EnableServiceTicketsFetchOptions(tvmSecret, {targetTvmId});
        auto tvm = MakeAtomicShared<NTvmAuth::TTvmClient>(clientSettings, CreateGlobalTvmLogger());
        NDrive::TTvmAuth tvmAuth(tvm, targetTvmId);
        NDrive::TTaxiSurgeCalculator client(options, tvmAuth);
        auto surgeFuture = client.GetMapSurge({37.395744, 55.644466});
        surgeFuture.Wait();
        UNIT_ASSERT_C(!surgeFuture.HasException(), NThreading::GetExceptionMessage(surgeFuture));
        UNIT_ASSERT(surgeFuture.HasValue());
        auto surge = surgeFuture.GetValue();
        UNIT_ASSERT(!surge.Classes.empty());
        for (auto&& element : surge.Classes) {
            Cerr << element.Name << ": " << element.Value << Endl;
        }
    }
}
